/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.lang.reflect.Method;

import javax.ejb.EJBException;

import com.sun.ejb.containers.util.InvocationHandlerUtil;

/** 
 * This is an invocation handler for a remote EJB 3.x business
 * interface.  It is used to convert invocations made on the
 * EJB 3.0 business interface to its corresponding RMI-IIOP 
 * object.
 *
 * @@@ Need to handle serialization/deserialization
 *
 * @author Kenneth Saks
 */    

public final class RemoteBusinessIntfInvocationHandler  
    implements InvocationHandler, Serializable {

    private Class businessInterface;
    private java.rmi.Remote delegate;

    public RemoteBusinessIntfInvocationHandler(Class businessIntf,
                                               java.rmi.Remote stub) {
        businessInterface = businessIntf;
        delegate = stub;
    }

    public Object invoke(Object proxy, Method method, Object[] args) 
        throws Throwable {

        // NOTE : be careful with "args" parameter.  It is null
        //        if method signature has 0 arguments.

        Class methodClass = method.getDeclaringClass();
        if( methodClass == java.lang.Object.class )  {
            return InvocationHandlerUtil.
                invokeJavaObjectMethod(this, method, args);    
        }

        Object returnValue = null;
        Throwable t = null;
        try {
            Method m = delegate.getClass().getMethod
                (method.getName(), method.getParameterTypes());
                                                     
            returnValue = m.invoke(delegate, args);
        } catch(NoSuchMethodException nsme) {
            t = nsme;
        } catch(InvocationTargetException ite) {
            t = ite.getCause();
        } catch(Throwable c) {
            t = c;
        }

        if( t != null ) {
            if( t instanceof java.rmi.RemoteException ) {
                EJBException ejbEx = new EJBException();
                ejbEx.initCause(t);
                throw ejbEx;
            } else {
                throw t;
            }
        }

        return returnValue;
    }
    
}
