/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers.util.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.appserv.util.cache.Constants;

import java.util.Map;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;

/**
 * An EJB(Local)Object cache that does not impose any limit on the 
 * number of entries
 *
 * @author Mahesh Kannan
 */
public class UnboundedEJBObjectCache
    extends BaseCache
    implements EJBObjectCache
{
    /**
     * default constructor
     */
    public UnboundedEJBObjectCache(String name) { super(); }
    
    /**
     * constructor with specified timeout
     */
    public UnboundedEJBObjectCache(String name, long timeout) {
        super();
    }
    
    public void init(int maxEntries, int numberOfVictimsToSelect,
            long timeout, float loadFactor, Properties props)
    {
        super.init(maxEntries, loadFactor, props);
    }
    
    public Object get(Object key, boolean incrementRefCount) {
        return super.get(key);
    }
    
    public Object put(Object key, Object value, boolean linkWithLru) {
        return super.put(key, value);
    }
    
    public Object remove(Object key, boolean decrementRefCount) {
        return super.remove(key);
    }
    
    public void setEJBObjectCacheListener(EJBObjectCacheListener listener) {
        //do nothing
    }
    
    protected void trimItem(CacheItem item) {
        
    }
    
    public Map getStats() {
        Map map = new HashMap();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(listSize = 0")
        .append("; cacheSize = ").append(getEntryCount())
        .append(")");
        map.put("_UnBoundedEJBObject ==> ", sbuf.toString());
        return map;
    }
    
}
