/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.distributed;

/**
 * DistributedReadOnlyBeanService defines the methods that can be used to 
 *  implement a distributed ReadOnly beans. An instance of 
 *  ReadOnlyBeanRefreshEventHandler is used to handle requests received from
 *  other server instances. An instance of  DistributedReadOnlyBeanNotifier is used to
 *  notify other server instances.
 *  
 * @author Mahesh Kannan
 * @see ReadOnlyBeanRefreshEventHandler
 */
public interface DistributedReadOnlyBeanService {

    /**
     * This is typically done during appserver startup time. One of the LifeCycle
     *  listeners will create an instance of DistributedReadOnlyBeanNotifier and
     *  register that instance with DistributedReadOnlyBeanService 
     *   
     * @param notifier the notifier who is responsible for notifying refresh 
     *  event(s) to other instances
     */
    public void setDistributedReadOnlyBeanNotifier(
            DistributedReadOnlyBeanNotifier notifier);
    
    /**
     * Called from ReadOnlyBeanContainer to register itself as a 
     *  ReadOnlyBeanRefreshEventHandler. 
     *  
     * @param ejbID the ejbID that uniquely identifies the container
     * @param loader the class loader that will be used to serialize/de-serialize
     *  the primary key 
     * @param handler The handler that is responsible for
     *  correctly refresing the state of a RO bean
     */
    public void addReadOnlyBeanRefreshEventHandler(
            long ejbID, ClassLoader loader,
            ReadOnlyBeanRefreshEventHandler handler);
    
    /**
     * Called from ReadOnlyBeanContainer to unregister itself as a 
     *  ReadOnlyBeanRefreshEventHandler. Typically called during undeployment.
     *  
     * @param ejbID
     */
    public void removeReadOnlyBeanRefreshEventHandler(long ejbID);
    
    /**
     * Called by the container after it has refreshed the RO bean
     * 
     * @param ejbID the ejbID that uniquely identifies the container
     * @param pk the primary key to be refreshed
     */
    public void notifyRefresh(long ejbID, Object pk);
    
    /**
     * Called by the container after it has refreshed all RO beans
     * 
     * @param ejbID the ejbID that uniquely identifies the container
     */
    public void notifyRefreshAll(long ejbID);
    
    /**
     * Called from the DistributedReadOnlyBeanNotifier when it receives a (remote) 
     *  request to refresh a RO bean
     *  
     * @param ejbID the ejbID that uniquely identifies the container
     * @param pk the primary key to be refreshed
     */
    public void handleRefreshRequest(long ejbID, byte[] pkData);
    
    /**
     * Called from the DistributedReadOnlyBeanNotifier when it receives a (remote) 
     *  request to refresh all RO beans
     *  
     * @param ejbID the ejbID that uniquely identifies the container
     */
    public void handleRefreshAllRequest(long ejbID);
    
}
