/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.distributed;

/**
 * ReadOnlyBeanRefreshEventHandler defines the methods that can be used to 
 *  implement a distributed ReadOnly beans. An instance of 
 *  ReadOnlyBeanRefreshEventHandler is used to handle requests received from
 *  other server instances. An instance of  DistributedReadOnlyBeanNotifier is used to
 *  notify other server instances.
 *  
 * @author Mahesh Kannan
 * @see DistributedReadOnlyBeanService
 */
public interface ReadOnlyBeanRefreshEventHandler {

    /**
     * Called from DistributedReadOnlyBeanServiceImpl before de-serializing
     *  the bean's pk
     * @return the application class loader
     */
    public ClassLoader getClassLoader();
    
    /**
     * Called from DistributedReadOnlyBeanServiceImpl when a refresh message
     *  arrives at this instance
     * @param pk the primary key that needs to be refreshed
     */
    public void handleRefreshRequest(Object pk);
    
    /**
     * Called from DistributedReadOnlyBeanServiceImpl when a refreshAll message
     *  arrives at this instance
     */
    public void handleRefreshAllRequest();
    
}
