/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SFSBBeanState.java
 *
 * Created on May 12, 2003, 3:21 PM
 */

package com.sun.ejb.spi.sfsb;

/**
 *
 * @author  lwhite
 */
public class SFSBBeanState {
    
    /** Creates a new instance of SFSBBeanState */
    public SFSBBeanState(Object id, long lastAccess, boolean isNew, byte[] state) {
        _id = id;
        _lastAccess = lastAccess;
        _isNew = isNew;
        _state = state;
    }
    
    /** Creates a new instance of SFSBBeanState */
    public SFSBBeanState(Object id, long lastAccess, byte[] state) {
        _id = id;
        _lastAccess = lastAccess;
        _state = state;
    }
    
    /**
     * @return id (key)
     */    
    public Object getId() {
        return _id;
    }
    
    /**
     * @return last access time
     */    
    public long getLastAccess() {
        return _lastAccess;
    }
    
    /**
     * @return isNew - true means not persistent; false means already persistent
     */    
    public boolean isNew() {
        return _isNew;
    }    
    
    /**
     * @return state
     */    
    public byte[] getState() {
        return _state;
    }
    
    private Object _id = null;
    private long _lastAccess = 0L;
    private boolean _isNew = false;
    private byte[] _state = null;
    
}
