/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SFSBStoreManager.java
 *
 * Created on May 12, 2003, 5:00 PM
 */

package com.sun.ejb.spi.sfsb;

import java.util.Map;

import com.sun.ejb.spi.monitorable.sfsb.MonitorableSFSBStore;

/**
 *
 * @author  lwhite
 */
public interface SFSBStoreManager {
    
    /**
     * Called from the Container during container creation
     */
    public void initSessionStore(Map storeEnv);
    
    /**
     * Return the SFSBBeanState containing 
     * the stored session data identified by this sessionKey
     * @return the SFSBBeanState containing stored session data or null if the sessionKey is invalid / removed
     */

    public SFSBBeanState getState(Object id);     
     
    /**
     * Store session data in this beanState
     * This method used only for passivation; use checkpointSave for checkpointing
     */
    public void passivateSave(SFSBBeanState beanState);
      
    /**
     * Remove the session data identified by this id
     */
    public void remove(Object id);
      
    /**
     * Remove all the idle/expired session data 
     * that are idle for idleTimeoutInSeconds (passed during initSessionStore())
     */
    public void removeExpired(); 
      
    /**
     * Remove all session data for this container
     * called during undeployment
     */
    public void removeAll(); 
      
    /**
     * Called during shutdown of instance
     */
    public void shutdown();
      
    /**
     * return the SFSBUUIDUtil
     * @return the SFSBUUIDUtil instance
     */
    public SFSBUUIDUtil getUUIDUtil();


    /**
     *Get the SFSBStoreManagerMonitor
     */
    public MonitorableSFSBStore getMonitorableSFSBStore();

    public int getCurrentSize();

}
