/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ServiceRefApf.java
 *
 * Created on June 15, 2005, 8:57 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package com.sun.enterprise;

import java.util.Collection;
import java.util.Collections;
import java.util.Arrays;
import java.util.Set;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessor;

import com.sun.enterprise.deployment.backend.DeploymentLogger;

import com.sun.enterprise.webservice.apt.WebServiceRefAp;

/**
 * Factory class for all APT handlers delivered with the application and 
 * available with the asapt command.
 *
 * @author Jerome Dochez
 */
public class AptFactory implements AnnotationProcessorFactory {
    
    // Process this set of annotations
    private static final Collection<String> supportedAnnotations
        = Collections.unmodifiableCollection(Arrays.asList("javax.xml.ws.WebServiceRef"));    
    
    // No supported options
    private static final Collection<String> supportedOptions = Collections.emptySet();
    
    /** Creates a new instance of ServiceRefApf */
    public AptFactory() {
        DeploymentLogger.get().fine("APT found ServiceRefApf");
    }
 
    /**
     * @return the list of supported annotations
     */
    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(
            Set<AnnotationTypeDeclaration> atds,
            AnnotationProcessorEnvironment env) {
        return new WebServiceRefAp(env);
    }    
}
