/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise;

import java.lang.InheritableThreadLocal;
import java.util.Hashtable;

/**
 * This class that implements ExecutionContext that gets 
 * stored in Thread Local Storage. If the current thread creates
 * child threads, the context info that is  stored in the current 
 * thread is automatically propogated to the child threads.
 * 
 * Two class methods serve as a convinient way to set/get the 
 * Context information within the current thread.   
 *
 * Thread Local Storage is a concept introduced in JDK1.2. So, it
 * will not work on earlier releases of JDK.
 *
 * @see java.lang.ThreadLocal
 * @see java.lang.InheritableThreadLocal
 * 
 */
public class ExecutionContext {
    private static InheritableThreadLocal current= new InheritableThreadLocal();

    /** 
     * This method can be used to add a new hashtable for storing the 
     * Thread specific context information. This method is useful to add a 
     * deserialized Context information that arrived over the wire.
     * @param A hashtable that stores the current thread's context
     * information.
     */
    public static void setContext(Hashtable ctxTable) {
	if (ctxTable != null) {
	    current.set(ctxTable);
	} else {
	    current.set(new Hashtable());
	}
    }

    /**
     * This method returns the hashtable that stores the thread specific
     * Context information.
     * @return The Context object stored in the current TLS. It always 
     * returns a non null value;
     */
    public static Hashtable getContext() {
	 if (current.get() == null) {
	     setContext(null); // Create a new one...
	 } 
	 return (Hashtable) current.get();
    }
}





