/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

import java.io.Serializable;
import java.util.Properties;

import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.StringValidator;

/**
    A class representing the <code> information </code> on one JMS destination
    created by the JMS provider.

   @author  Isa Hashim
    @version  1.0
*/

public class JMSDestinationInfo implements Serializable
{
    private String	destName,
			destType;
    private Properties	attrs;

    public JMSDestinationInfo (String destName, String destType)
    {
        ArgChecker.checkValid(destName, "destName", 
                              StringValidator.getInstance()); //noi18n
        ArgChecker.checkValid(destType, "destType", 
                              StringValidator.getInstance()); //noi18n

        this.destName = destName;
        this.destType = destType;
        this.attrs = new Properties();
    }

    public JMSDestinationInfo (String destName, String destType, Properties attrs)
    {
        this(destName, destType);
        ArgChecker.checkValid(attrs, "attrs"); //noi18n
        this.attrs = attrs;
    }

    public String getDestinationName()  {
        return (destName);
    }

    public String getDestinationType()  {
        return (destType);
    }

    public Properties getAttrs()  {
        return (attrs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(destName);
        sb.append(' ');
        sb.append(destType);
        sb.append(' ');
        sb.append(attrs);
        return sb.toString();
    }
}
