/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

//JDK imports
import java.io.Serializable;

/**
	A class that denotes the Progress of an operation carried out earlier.
*/

public class OperationProgress implements Serializable
{
	/* javac 1.3 generated serialVersionUID */
	public static final long serialVersionUID	= -5562129808433683519L;
	
	private boolean			mIsFinished			= false;
	private String			mMessage			= null;
	private int				mPercentage			= 0;
	
	public OperationProgress()
	{
		mIsFinished = false;
		mPercentage = 0;
		mMessage	= "STARTED"; //i18n ?
	}
	/** 
		Creates new OperationProgress 
	*/
    public OperationProgress (int percentage, String message)
	{
		if (percentage < 0 || percentage > 100)
		{
			throw new IllegalArgumentException();
		}
		if (percentage == 100)
		{
			mIsFinished = true;
		}
		mPercentage = percentage;
		mMessage	= message;
    }
	
	/**
		Returns the percentage indicating amount of work done.
	 
		@return int x such that 0 <= x <= 100.
	*/
	
	public int getPercentage()
	{
		return ( mPercentage );
	}
	
	/**
		Returns a boolean indicating whether the work is finished.
	*/
	
	public boolean isFinished()
	{
		return ( mIsFinished );
	}
	
	/*
		Returns a String representing the message associated with this
		stage of the entire work.
	 
		@return String indicating phase of work.
	*/
	public String getMessage()
	{
		return ( mMessage );
	}
	
	/**
		Sets the percentage to given value. The value may not be greater than
		100 or less than 0. If the value is 100, the internal state of this
		Object will be set to finished.
		
		@param percentage integer representing the percentage of work done.
	*/
	
	public void setPercentage(int percentage)
	{
		if (percentage < 0 || percentage > 100)
		{
			throw new IllegalArgumentException();
		}
		mPercentage = percentage;
		if (percentage == 100)
		{
			mIsFinished = true;
		}
	}
	
	/**
		Sets the state to finished or unfinished. If the parameter is true,
		the internal state of the Object will be modified to show the percentage
		as 100.
		@param boolean representing whether work is done.
	*/
	public void setIsFinished(boolean finished)
	{
		mIsFinished = finished;
		if (finished)
		{
			setPercentage(100);
		}
	}
}