/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.domains.registry;
/**
   Instances of this class represent an exception from the domain
   registry abstraction.
   <p>
   Subclasses indicate specific issues from that abstraction
*/
import java.security.PrivilegedActionException;

public class DomainRegistryException extends Exception
{
	  /**
		 Constructs a new exception with null as its detail
   message. The cause is not initialized, and may subsequently be
   initialized by a call to  {@link Throwable#initCause(Throwable)}
	  */

  public DomainRegistryException(){
	super();
  }

	  /**
		 Constructs a new exception with the specified detail
		 message. The cause is not initialized, and may subsequently
		 be initialized by a call to {@link Throwable#initCause(Throwable)}

		 @param message - the detail message. The detail message is
		 saved for later retrieval by the {@link Throwable#getMessage()} method.
	  */
  public DomainRegistryException(String message){
	super(message);
  }

	  /**
		 Constructs a new exception with the specified detail message and cause. 
		 <p>
		 Note that the detail message associated with cause is not
		 automatically incorporated in this exception's detail
		 message.

		 @param message - the detail message (which is saved for later
		 retrieval by the {@link Throwable#getMessage()} method).
		 @param cause - the cause (which is saved for later retrieval by the
		 {@link Throwable#getCause()} method). (A null value is
		 permitted, and indicates that the cause is nonexistent or
		 unknown.)
	  */
  public DomainRegistryException(String message,
				   Throwable cause){
    super(message+" "+cause.getMessage());
    this.cause = cause;
  }

	  /**
		 Constructs a new exception with the specified cause detail
		 message. The 
		 detail message will be <code>(cause==null ? null :
		 cause.toString())</code> (which typically contains the class
		 and detail message of cause). This constructor is useful for
		 exceptions that are little more than wrappers for other
		 throwables (for example, {@link PrivilegedActionException}).

		 @param cause - the cause (which is saved for later retrieval
		 by the {@link Throwable#getCause()} method). (A null value is
		 permitted, and indicates that the cause is nonexistent or
		 unknown.)
	  */
  public DomainRegistryException(Throwable cause){
    super(cause.getMessage());
    this.cause = cause;
  }

  private Throwable cause;
		 
}
