/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event;

import java.util.Set;

/* Tests the event locator and query
 * parts of notification
 *
 * @author Satish Viswanatham
 */
public class QueryTest {
    
    public static void main (String[] args) {

        if ( args.length < 1 ) {
            System.out.println(" Usage: <mbean name>"); 
        }
        
        AdminEventManager am = AdminEventManager.getAdminEventManager();
        MBeanLocator mloc = am.getMBeanLocator();

        // this test can be changed to take the diff query object
        // to test the functionality
        // this only tests null key
        
        EventKey ek = new EventKey(args[0], null);
        Set s = (Set) mloc.locate(ek);
        System.out.println("The number of mbeans matched are " + s.size());

    }
}
