/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event.pluggable;

import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.enterprise.admin.event.RRPersistenceHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.event.ElementChangeHelper;


//i18n import
import com.sun.enterprise.util.i18n.StringManager;

/**
 * Restart event Helper - class providing support for informing
 * server(s) to set its(their) restart required state to true or false.
 *
 * @author: Satish Viswanatham
 */
public class PERestartEventHelper implements RestartEventHelper{

    // i18n StringManager
    private static Logger _logger     = null;
    
    public PERestartEventHelper() {
    }

    /**
     * Given a config change list, this method figures out if that list contains
     * any non dynamic recofigurable changes. If there is any change which can
     * not be applied dynamically, if sets the restart status on the appropriate
     * target servers.
     *
     * @param ctx        Config context of DAS 
     * @param list       config change list
     */
    public void setRestartRequiredForTarget(ConfigContext ctx, 
            ArrayList configChangeList ) {
   
        try {
            AdminService admServ = AdminService.getAdminService();

            if ((admServ != null) && (admServ.isDas())) {
                Set nonDynSet = ElementChangeHelper.
                    getXPathesForDynamicallyNotReconfigurableElements(
                    configChangeList);

                Set targetSet = new HashSet();
                Iterator iter = nonDynSet.iterator();

                if (iter.hasNext()) {
                    RRPersistenceHelper rrHelper = new RRPersistenceHelper();
                    rrHelper.setRestartRequired(true);
                }
            }
        } catch (Throwable t) {
            getLogger().log(Level.INFO, "event.exception_during_restart_reset",
                        t);
        }

    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger(LogDomains.ADMIN_LOGGER);
        }
        return _logger;
    }

}
