/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event.tx;

import com.sun.enterprise.admin.event.*;

//i18n import
import com.sun.enterprise.util.i18n.StringManager;

/**
 * TransactionsRecoveryEvent - emitted by DAS to send requests to Ejb Timer Service
 * Attibutes: actionType, from, servers
 */
public class TransactionsRecoveryEvent extends AdminEvent implements CommandEvent {

    /**
     * Event type
     */
    public static final String eventType = TransactionsRecoveryEvent.class.getName();

    /**
     * Attributes ()
     */
    private String   _serverName;    //server instance name to recover
    private String   _logDir;        //path to log files directory (can be null)

    /**
     * Create a new TransactionsRecoveryEvent.
     * @param instance name of the instance to which the event applies
     * @param serverNameToRecover name of server instance to recover transactions
     * @param logDirPath - path to log files directory (can be null)
     */
    public TransactionsRecoveryEvent(String instance, String serverNameToRecover, String logDirPath) {
        this(eventType, instance, serverNameToRecover, logDirPath);
    }

    /**
     * Create a new TransactionsRecoveryEvent.
     * @param type event type, a string representation for the event
     * @param instance name of the instance to which the event applies
     * @param serverNameToRecover name of server instance to recover transactions
     * @param logDirPath - path to log files directory (can be null)
     */
    public TransactionsRecoveryEvent(String type, String instance, String serverNameToRecover, String logDirPath) {
        super(type, instance);
        _serverName = serverNameToRecover;
        _logDir  = logDirPath;
    }

    /**
     * Get serverName param
     */
    public String getServerName() {
        return _serverName;
    }

    /**
     * Get logdir param
     */
    public String getLogDir() {
        return _logDir;
    }
}
