/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.monitor.types;

/**
 * Base Type for monitored attribute. In general, a monitored attribute value
 * is of the type of one of the common java types (String, Integer etc.).
 * However, jmx model proposes one MBean for every monitorable attribute and
 * proposes interfaces like javax.management.monitor.CounterMonitorMBean,
 * javax.management.monitor.GaugeMonitorMBean,
 * javax.management.monitor.StringMonitorMBean for monitoring MBeans. For iAS7
 * SE, there is no plan to manage MBeans for every monitorable attribute, but
 * for future enhancements, it is good to associate these types to every
 * monitored attribute, so if needed appropriate MBeans can be created.
 * Since this object is a workaround to get appropriate MBean created, there
 * will be no value associated with these objects. The monitored attribute
 * values will still be available as an object of type returned by the method
 * getJavaType().
 */
public class MonitoredAttributeType {

    /**
     * Java type for the monitored attribute
     */
    private Class javaType;

    /**
     * Create a monitored attribute type for a monitored attribute whose
     * values are of specified javaType.
     */
    protected MonitoredAttributeType(Class javaType) {
        this.javaType = javaType;
    }

    /**
     * Get java type for this monitored attribute type
     */
    public Class getJavaType() {
        return javaType;
    }

    /**
     * Get java class name for this monitored attribute type
     */
    public String getJavaTypeName() {
        return javaType.getName();
    }
}
