/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EventAbstractFactory.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;

import javax.management.MBeanServer;
import javax.management.NotificationEmitter;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;



/**
 *
 * @author Sun Micro Systems, Inc
 */
public abstract class EventAbstractFactory {
    
    private MBeanServer mbeanServer;
    protected static StringManager sm = StringManager.getManager(EventAbstractFactory.class);
    protected static Logger _logger = LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
    
    public EventAbstractFactory( ) {
        mbeanServer =
                MBeanServerFactory.getMBeanServer();
    }
    
    public abstract Event instrumentEvent(
            ElementProperty[] properties, String description );
    
    public MBeanServer getMBeanServer( ) {
        return mbeanServer;
    }
}
