/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.selfmanagement.event;
import javax.management.ObjectName;
import javax.management.NotificationFilter;
import javax.management.monitor.Monitor;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;


public class MonitorEvent implements Event {
    private static Logger _logger=LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
    private static StringManager sm = StringManager.getManager(MonitorEvent.class);
    
    MonitorEvent(StatisticMonitor monitor, ObjectName objName, String description) {
        monitor.start();
        try {
            MBeanServerFactory.getMBeanServer().registerMBean(monitor,objName);
        } catch (Exception ex) {
            _logger.log(Level.WARNING,"smgt.internal_error", ex);
        }
        
        this.sMonitor = monitor;
        this.objName = objName;
        if (description != null)
            this.description = description;
        else
            this.description = defaultDescription;
    }

    MonitorEvent(Monitor monitor, ObjectName objName, String description) {
        monitor.start();
        try {
            MBeanServerFactory.getMBeanServer().registerMBean(monitor,objName);
        } catch (Exception ex) {
            _logger.log(Level.WARNING,"smgt.internal_error", ex);
        }

        this.monitor = monitor;
        this.objName = objName;
        if (description != null)
            this.description = description;
        else
            this.description = defaultDescription;
    }
    
    
    public ObjectName getObjectName() {
        return objName;
    }
    public String getType() {
        return "monitor";
    }
    public NotificationFilter getNotificationFilter() {
        return null;
    }
    public String getDescription() {
        return description;
    }
    public void destroy() {
        try {
        if (monitor != null)
            monitor.stop();
        if (sMonitor != null)
            sMonitor.stop();
        } catch (Exception ex) {
            _logger.log(Level.WARNING,"smgt.internal_error", ex);
        }
        try {
            MBeanServerFactory.getMBeanServer().unregisterMBean(objName);
        } catch (Exception ex) {
            _logger.log(Level.WARNING,"smgt.internal_error", ex);
        }
    }
    private ObjectName objName = null;
    private static String description = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.monitor_event_description");
    private StatisticMonitor sMonitor = null;
    private Monitor monitor = null;
}
