/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TraceEventFactory.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;


import javax.management.NotificationEmitter;
import javax.management.MBeanServer;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import java.util.logging.Level;
import static com.sun.enterprise.admin.selfmanagement.event.ManagementRuleConstants.*;

/**
 *
 * @author Sun Micro Systems, Inc
 */

public class TraceEventFactory extends EventAbstractFactory {
    
    private TraceEventFactory( ) {
        super();
        EventBuilder.getInstance().addEventFactory(EVENT_TRACE, this);
        try {
            TraceEventImpl impl = (TraceEventImpl) getMBeanServer().instantiate(
                    "com.sun.enterprise.admin.selfmanagement.event.TraceEventImpl");
            getMBeanServer().registerMBean(impl,TraceEvent.getTraceImplObjectName());
        } catch (javax.management.ReflectionException rex) {
            _logger.log(Level.WARNING,"smgt.internal_error", rex);
        } catch (javax.management.InstanceAlreadyExistsException iex) {
            _logger.log(Level.WARNING,"smgt.internal_error", iex);
        } catch (Exception ex) {
            _logger.log(Level.WARNING,"smgt.internal_error", ex);
            
        }
    }

    private  synchronized void enableNotifications(boolean enable) {
        if (!notificationsEnabled) {
            CallflowEventListener.register();
            notificationsEnabled = true;
        } else if (!enable) {
            CallflowEventListener.unregister();
        }
    }
    
    public Event instrumentEvent(
            ElementProperty[] properties, String description ) {
        enableNotifications(true);
        String eventName = "*";
        String ipAddress = "*";
        String callerPrincipal = "*";
        String componentName = "*";
        for( int i = 0; i < properties.length; i++ ){
            ElementProperty property = properties[i];
            String propertyName = property.getName( ).toLowerCase( );
            if( propertyName.equals(PROPERTY_TRACE_NAME)) {
                eventName = "trace." + property.getValue( ).toLowerCase( );
                if (!TraceEvent.isValidType(eventName))
                    throw new IllegalArgumentException(
                            sm.getString(PROPERTY_TRACE_NAME,
                            "selfmgmt_event.invalid_event_property",EVENT_TRACE));
            }
            if(propertyName.equals(PROPERTY_TRACE_IPADDRESS)) {
                ipAddress = property.getValue( ).toLowerCase( );
            }
            if(propertyName.equals(PROPERTY_TRACE_CALLERPRINCIPAL)) {
                callerPrincipal  = property.getValue( ).toLowerCase( );
            }
            if(propertyName.equals(PROPERTY_TRACE_COMPONENTNAME)) {
                componentName  = property.getValue( ).toLowerCase( );
            }
        }
        return new TraceEvent(eventName, 
                   new TraceEventNotificationFilter(eventName, ipAddress, callerPrincipal, componentName), 
                   description);
    }
    
    static TraceEventFactory getInstance() {
        return instance;
    }
    private boolean notificationsEnabled = false;
    private static TraceEventFactory instance = new TraceEventFactory();
}
