/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
    PROPRIETARY/CONFIDENTIAL. Use of this product is subject
    to license terms. Copyright (c) 2002 Sun Microsystems, Inc.
        All rights reserved.
 
    $Id: ConfigMBeanNamingInfo.java,v 1.4 2005/12/25 04:14:34 tcfujii Exp $
 */

package com.sun.enterprise.admin.server.core.mbean.config.naming;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.MalformedNameException;

import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;

//JMX imports
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;

//i18n import
import com.sun.enterprise.util.i18n.StringManager;


/**
 * Provides naming support for ConfigMbeans
 */
public class ConfigMBeanNamingInfo
{
    private AdminContext m_AdminContext;
    String[] m_ids = null;
    MBeanNamingDescriptor m_descr = null;

	// i18n StringManager
	private static StringManager localStrings =
		StringManager.getManager( ConfigMBeanNamingInfo.class );

    public ConfigMBeanNamingInfo(String type, String[] params) throws MBeanConfigException
    {
       this(type, params, true);
    }
    public ConfigMBeanNamingInfo(String type, String[] params, boolean bTestParamSize) throws MBeanConfigException
    {
        m_descr = ConfigMBeansNaming.findNamingDescriptorByType(type);
        if(m_descr==null) {
			String msg = localStrings.getString( "admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_type", type );
            throw new MBeanConfigException( msg );
		}

        if(bTestParamSize)
        {
            int parmSize = (params==null)?0:params.length;
            if(m_descr.getParmListSize()!=parmSize) {
				String msg = localStrings.getString( "admin.server.core.mbean.config.naming.wrong_parameters_array_size", type );
                throw new MBeanConfigException( msg );
			}
        }
        m_ids   = params;
    }
    
    public ConfigMBeanNamingInfo(String dottedName) throws MBeanConfigException, MalformedNameException
    {
        m_descr = ConfigMBeansNaming.findNamingDescriptor(dottedName);
        if(m_descr==null) {
			String msg = localStrings.getString( "admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_dotted_name", dottedName );
            throw new MBeanConfigException( msg );
		}
        m_ids   = m_descr.extractParmList(dottedName);
    }
    
    public ConfigMBeanNamingInfo(ObjectName objectName) throws MBeanConfigException
    {
        m_descr = ConfigMBeansNaming.findNamingDescriptor(objectName);
        if(m_descr==null) {
			String msg = localStrings.getString( "admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_object_name", objectName );
            throw new MBeanConfigException( msg );
		}
        m_ids   = m_descr.extractParmList(objectName);
    }

    public void setAdminContext(AdminContext adminContext) {
        m_AdminContext = adminContext;
    }
    
    //******************************M A P P I N G S***************************
    public ObjectName getObjectName() throws MalformedObjectNameException
    {
        return m_descr.createObjectName(m_ids);
    }

    public String[] getLocationParams() 
    {
        return m_ids;
    }

    public String getXPath() 
    {
        return m_descr.createXPath(m_ids);
    }

    public int getMode() 
    {
        return m_descr.getMode();
    }

    public boolean isModeConfig() 
    {
        int mode = m_descr.getMode();
        return ((mode&MBeansDescriptions.MODE_CONFIG)!=0);
    }

    public boolean isModeMonitorable() 
    {
        int mode = m_descr.getMode();
        return ((mode&MBeansDescriptions.MODE_MONITOR)!=0);
    }

    public ConfigMBeanBase constructConfigMBean() throws MBeanConfigException
    {
        String className = MBeansDescriptions.CONFIG_MBEANS_BASE_CLASS_PREFIX + m_descr.getMBeanClassName();
        Class cl;
        ConfigMBeanBase configMBean;
        try
        {
            cl = Class.forName(className);
            //create configMBean by defaul constructor;
            configMBean  = (ConfigMBeanBase)cl.newInstance();
        }
        catch (Exception e)
        {
			String msg = localStrings.getString( "admin.server.core.mbean.config.naming.mbeannamingdescriptor_couldnot_create_mbean_class", className );
            throw new MBeanConfigException( msg );
        }
        configMBean.setAdminContext(m_AdminContext);
        configMBean.initialize(this);
        return configMBean;
    }

    public String getServerInstanceName()  throws MBeanConfigException
    {
        if(m_ids==null || m_ids.length==0)
        {
            String msg = localStrings.getString( "admin.server.core.mbean.config.naming.wrong_parameters_array_size", m_descr.getType() );
            throw new MBeanConfigException( msg );
        }
        return m_ids[0];
    }

}
