/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.servlet;

//j2ee imports
import javax.servlet.*;
import javax.servlet.http.*;

//jdk imports
import java.io.IOException;
import java.io.PrintWriter;


/**
    A simple Servlet to test the connectivity of API layer.
    @author Kedar Mhaswade
    @version 1.0
*/

public class ConnectServlet extends HttpServlet
{

    public void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
    {
        doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response)
    	throws ServletException, IOException
    {
	    PrintWriter		out;
	    String		title = "Simple Servlet Output";

	    // set content type and other response header fields first
        response.setContentType("text/html");

	    // then write the data of the response
	    out = response.getWriter();

        out.println("<HTML><HEAD><TITLE>");
	    out.println(title);
	    out.println("</TITLE></HEAD><BODY>");
	    out.println("<H1>" + title + "</H1>");
	    out.println("<P> This means you are connected to the Admin API Servlet Layer.");
	    out.println("</BODY></HTML>");
	    out.close();
    }
}