/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: ClusterTarget.java,v 1.3 2005/12/25 04:14:38 tcfujii Exp $
 */

package com.sun.enterprise.admin.target;

//jdk imports
import java.io.Serializable;

//config imports
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.NodeAgent;

public class ClusterTarget extends Target
{
    protected ClusterTarget(String name, ConfigContext cc)
    {
        super(name, cc);
    }

    public TargetType getType()
    {
        return TargetType.CLUSTER;
    }

    public String getTargetObjectName(String[] tokens)
    {
        checkTokens(tokens, 1);
        return (tokens[0] + ":type=cluster,category=config,name=" + getName());
    }

    public ConfigTarget getConfigTarget() throws Exception
    {
        return new ConfigTarget(getConfigRef(), getConfigContext());
    }

    public String getConfigRef() throws ConfigException
    {
        final Config config = ClusterHelper.getConfigForCluster(getConfigContext(), getName());
        return config.getName();
    }
    
    /**
     * Return all the servers in the cluster
     */
    public Server[] getServers() throws ConfigException
    {
        return ServerHelper.getServersInCluster(getConfigContext(), getName());
    }
    
    /**
     * Return the cluster
     */
    public Cluster[] getClusters() throws ConfigException
    {
        final Cluster[] clusters = new Cluster[1];
        clusters[0] = ClusterHelper.getClusterByName(getConfigContext(), getName());
        return clusters;
    }
    
    /**
     * Return the configuration referenced by the cluster
     */
    public Config[] getConfigs() throws ConfigException
    {
        final Config[] configs = new Config[1];        
        configs[0] = ClusterHelper.getConfigForCluster(getConfigContext(), getName());
        return configs;
    }
    
    /**
     * Return all the node agents that have instances that are part of the cluster
     */
    public NodeAgent[] getNodeAgents() throws ConfigException
    {
        return NodeAgentHelper.getNodeAgentsForCluster(getConfigContext(), getName());
    }        
    
    /**
     * Return all the application refs of the cluster
     */
    public ApplicationRef[] getApplicationRefs() throws ConfigException
    {
        return ClusterHelper.getApplicationReferences(getConfigContext(), getName());        
    }
    
    /**
     * Return all the resource refs of the cluster
     */    
    public ResourceRef[] getResourceRefs() throws ConfigException
    {
        return ClusterHelper.getResourceReferences(getConfigContext(), getName());        
    }    
}
