/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.util;

/**
	Provides wrapper to direct logging messages to some kind of output.
	
 */
public class Logger
{
	private final static int 	LOG_BASE	= 13;
	// caution: this are assumed to be in order
	public final static int		LOG_OFF		= LOG_BASE;
	public final static int		LOG_ERRORS	= LOG_BASE + 1;
	public final static int		LOG_DEBUG	= LOG_BASE + 2;
	
	static private Logger		 mInstance	= new Logger();
	
	
	static protected int	 sLogLevel	= LOG_DEBUG;
	
	
	Logger()
	{
	}
	
		protected void
	_log( String msg )
	{
		System.out.println( msg );
	}
	
	
	//--------------------------------------------------------
	
	/**
		set the log level; return the old log level
	 */
		public static int
	setLogLevel( int logLevel )
	{
		int	oldLevel	= getLogLevel();
		
		Assert.assertit(	logLevel != LOG_OFF &&
						logLevel != LOG_ERRORS &&
						logLevel != LOG_DEBUG, "illegal log level" );
						
		sLogLevel	= logLevel;
			
		return( oldLevel );
	}
	
		Logger
	getInstance()
	{
		return( mInstance );
	}
	
		public static int
	getLogLevel()
	{
		return( sLogLevel );
	}
	
	
	
	/**
		OK, but log( object ) preferred if it avoids
		generating a String from an object prior to the call.
	*/
		public static void
	log( String msg )
	{
		if ( sLogLevel >= LOG_DEBUG )
		{
			System.out.println( msg );
		}
	}
	
	/**
		optimization for the caller; caller can pass an object
		directly so that if logging is off, we won't ever call
		toString()
	*/
		public static void
	log( Object object )
	{
		if ( sLogLevel >= LOG_DEBUG && object != null )
		{
			log( object.toString() );
		}
	}
	
		public static void
	logError( String msg )
	{
		if ( sLogLevel >= LOG_ERRORS && msg != null )
		{
			log( msg );
		}
	}
	
		public static void
	logFatal( String msg )
	{
		// always log
		log( msg );
	}
};

