/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

import java.net.URI;

/**
 *Records information about fixed files installed with the app server
 *that are to be served to Java Web Start.
 *
 * @author tjquinn
 */
    
public class AppserverContentOrigin extends ContentOrigin {
    
    private String category;
    private String subcategory;
    
    public AppserverContentOrigin(String category, String subcategory) {
        super();
        this.category = category;
        this.subcategory = subcategory;
    }
    
    /**
     *Returns whether this appserver content origin is currently enabled.
     *<p>
     *App server content is always enabled, so this always returns true.
     *@return whether this appserver content origin is enabled (always true)
     */
    public boolean isEnabled() {
        return true;
    }
    
    public String getContentKeyPrefix() {
        String result = NamingConventions.Appserver.contentKeyPrefix(this);
        return result;
    }
    
    public String getSubcategory() {
        return subcategory;
    }
    
    public String getCategory() {
        return category;
    }
    
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        return sb.append(", category=").append(category).append(", subcategory=").append(subcategory).toString();
    }
}
