/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

/**
 *Abstract superclass of all types of content.
 *
 * @author tjquinn
 */
    
public abstract class Content {

    protected final String lineSep = System.getProperty("line.separator");

    /**
     *The path to the content as specified in URLs.  This is the "virtual"
     *path.  
     */
    private String path;

    /**
     *The key by which this content can be looked up in the content map.
     */
    protected String contentKey;
    
    /** The origin that owns this content. */
    private ContentOrigin origin;

    /** Creates a new instance of Content */
    public Content(ContentOrigin origin, String contentKey, String path) {
        this.origin = origin;
        this.contentKey = contentKey;
        this.path = path;
    }

    /**
     *Returns the virtual path within the content's subcategory to the content.
     *
     */
    public String getPath() {
        return path;
    }

    /**
     *Returns the content key for this content.
     *<p>
     *Prefixing a slash makes it easier to compare this to the pathInfo from
     *an incoming HTTP request that is seeking content.
     */
    public String getContentKey() {
        return contentKey;
    }

    /**
     *Returns the content origin which owns this content.
     *@return ContentOrigin for the owning origin
     */
    public ContentOrigin getOrigin() {
        return origin;
    }
    
    /**
     *Returns a string representation of the content.
     * <p>
     * Even though Content is abstract, subclasses use super.toString().
     */
    public String toString() {
        return getClass().getName() + ": content key=" + getContentKey() + ", path=" + getPath();
    }
}
