/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.admin.common.exception.IllegalStateException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.ModuleDescriptor;

/**
 *Represents a nested (embedded) app client as an origin of content.
 *
 * @author tjquinn
 */
public class NestedAppclientContentOrigin extends AppclientContentOrigin {
  
    /** the origin corresponding to the embedded app client's enclosing parent application */
    private ApplicationContentOrigin parent;
    
    /** unique identifier for this embedded app client within its parent */
    private String name;
    
    /**
     *Creates a new instance of NestedAppclientContentOrigin
     *@param the parent ApplicationContentOrigin object
     *@param the ModuleDescriptor for this embedded app client
     *@param the context root by which this app client's content is to be addressable
     */
    public NestedAppclientContentOrigin(ApplicationContentOrigin parent, ModuleDescriptor moduleDescr, String contextRoot) {
        super(parent.getApplication(), moduleDescr, contextRoot);
        this.parent = parent;
        this.name = NamingConventions.NestedAppclient.archiveURIToName(moduleDescr.getArchiveUri());
    }
    
    /**
     *Returns whether this nested app client's parent application is currently
     *enabled for Java Web Start access.
     */
    public boolean isEnabled() {
        return parent.isEnabled();
    }
    
    /**
     *Returns the registration name for the top-level module associated with this
     *nested app client.
     *<p>
     *This method is primarily used to get a name to use in checking whether 
     *the relevant module has been enabled or disabled for Java Web Start access.
     *This implementation returns the name from the parent, whereas top-level
     *app clients return their own reg. name.
     *@return the parent's registration name
     */
    public String getTopLevelRegistrationName() {
        return parent.getApplication().getRegistrationName();
    }
    
    /**
     *Returns the parent origin of this nested app client origin.
     *@return the parent ApplicationContentOrigin 
     */
    public ApplicationContentOrigin getParent() {
        return parent;
    }
    
    /**
     *This method should not be called.  To prevent the superclass's method
     *from gaining control in case of an inadvertent invocation, throw an
     *exception.
     *@return the path to the client jar file
     */
    public String getAppclientJarPath() {
        throw new RuntimeException("Unexpected invocation");
    }
    
    public String toString() {
        return super.toString() + lineSep + ", parent=" + getTopLevelRegistrationName();
    }
    
    /**
     *Returns the prefix for the content map key that is common to all content from this origin.
     *@return the common content key prefix
     */
    public String getContentKeyPrefix() {
        return NamingConventions.NestedAppclient.contentKeyPrefix(this);
    }
    
    public String getVirtualPath() {
        return NamingConventions.NestedAppclient.virtualContextRoot(parent.application, moduleDescriptor);
    }
    
    /**
     *Returns the unique name for this embedded app client within its containing application.
     *@return the app client's name
     */
    public String getName() {
        return name;
    }

    protected String getTargetPath() {
        return NamingConventions.NestedAppclient.actualContextRoot(this);
    }
}
