/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

import 
      com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.*;
import com.sun.enterprise.config.serverbeans.*;

public class DeferredResourceConfig {


    private String rarName;
    private AdminObjectResource adminObject;
    private ConnectorConnectionPool connectionPool;
    private ConnectorResource connectorResource;
    private JdbcConnectionPool jdbcConnectionPool;
    private JdbcResource jdbcResource;
    private ResourceAdapterConfig[] resourceAdapterConfig;
    private ConfigBean[] resourcesToLoad; 


    public DeferredResourceConfig() {

    }

    public DeferredResourceConfig(
                String rarName,
                AdminObjectResource adminObject, 
                ConnectorConnectionPool connectionPool,
                ConnectorResource connectorResource,
                JdbcConnectionPool jdbcConnectionPool,
                JdbcResource jdbcResource,
                ResourceAdapterConfig[] resAdapterConfig) 
    {

        this.rarName = rarName;
        this.adminObject = adminObject;
        this.connectionPool = connectionPool;
        this.connectorResource = connectorResource;
        this.jdbcConnectionPool = jdbcConnectionPool;
        this.jdbcResource = jdbcResource;
        this.resourceAdapterConfig = resAdapterConfig;
        
    }

    public void setRarName(String rarName) {
        this.rarName = rarName;
    }

    public String  getRarName() {
        return this.rarName;
    }

    public void setAdminObject(AdminObjectResource adminObject) {
        this.adminObject = adminObject;
    }

    public AdminObjectResource  getAdminObject() {
        return this.adminObject;
    }
    public void setConnectorConnectionPool(
                          ConnectorConnectionPool connectionPool) 
    {
        this.connectionPool = connectionPool;
    }

    public ConnectorConnectionPool  getConnectorConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectorResource( ConnectorResource connectorResource) {
        this.connectorResource = connectorResource;
    }

    public ConnectorResource  getConnectorResource() {
        return this.connectorResource;
    }
    public void setJdbcConnectionPool( JdbcConnectionPool jdbcConnectionPool) {
        this.jdbcConnectionPool = jdbcConnectionPool;
    }

    public JdbcConnectionPool  getJdbcConnectionPool() {
        return this.jdbcConnectionPool;
    }
    public void setJdbcResource( JdbcResource jdbcResource) {
        this.jdbcResource = jdbcResource;
    }

    public JdbcResource  getJdbcResource() {
        return this.jdbcResource;
    }
    public void setResourceAdapterConfig( 
            ResourceAdapterConfig[] resourceAdapterConfig) 
    {
        this.resourceAdapterConfig = resourceAdapterConfig;
    }

    public ResourceAdapterConfig[]  getResourceAdapterConfig() {
        return this.resourceAdapterConfig;
    }
    public void setResourcesToLoad( ConfigBean[] resourcesToLoad) 
    {
        this.resourcesToLoad = resourcesToLoad;
    }

    public ConfigBean[]  getResourcesToLoad() {
        return this.resourcesToLoad;
    }
}
