/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.connectors;

import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.LazyAssociatableConnectionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.PoolManager;

/**
 * @author Aditya Gore
 */
public class LazyAssociatableConnectionManagerImpl extends ConnectionManagerImpl
        implements LazyAssociatableConnectionManager 
{
    public LazyAssociatableConnectionManagerImpl( String poolName ) {
        super( poolName );
    }
    
    public void associateConnection( Object connection, 
        javax.resource.spi.ManagedConnectionFactory mcf, 
        javax.resource.spi.ConnectionRequestInfo info ) 
        throws ResourceException
    {
        //the following call will also take care of associating "connection"
        //with a new ManagedConnection instance
        allocateConnection( mcf, info, jndiName, connection);
    }

}
