/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.authentication;

import java.util.HashMap;

/**
 * @author ko133006
 */
public class RuntimeSecurityMap {

    private HashMap userMap;

    private HashMap groupMap;

    public RuntimeSecurityMap() {
        this.userMap = new HashMap();
        this.groupMap = new HashMap();
    }

    public RuntimeSecurityMap(HashMap userMap, HashMap groupMap) {
        this.userMap = (HashMap) userMap.clone();
        this.groupMap = (HashMap) groupMap.clone();
    }

    public boolean equals(RuntimeSecurityMap map) {
        if (!(map.userMap.equals(this.userMap)))
            return false;
        else if (!(map.groupMap.equals(this.groupMap)))
            return false;
        else
            return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        // implement
        return sb.toString();
    }

    public boolean isEmpty() {
        if ((this.userMap.size() == 0) && (this.groupMap.size() == 0))
            return true;
        else
            return false;
    }

    public HashMap getUserMap() {
        return (HashMap) ((this.userMap).clone());
    }

    public HashMap getGroupMap() {
        return (HashMap) ((this.groupMap).clone());
    }

}
