/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.inflow;

/** 
 * Represents the properties of MDBContainer.
 * 
 * @author Binod P.G
 */
public class MdbContainerProps {

    private static int cmtMaxRuntimeExceptions; 
    private static int reconnectDelayInSeconds;
    private static int reconnectMaxRetries;
    private static boolean reconnectEnabled;

    /**
     * Sets the max runtime exception that are allowed.
     *
     * @param v value.
     */
    public static void setMaxRuntimeExceptions(int v){
        cmtMaxRuntimeExceptions = v;
    }

    /**
     * Retrives the max runtime exception that are allowed.
     *
     * @return int value 
     */
    public static int getMaxRuntimeExceptions() {
        return cmtMaxRuntimeExceptions;
    }

    /**
     * Sets the reconnect delay in seconds. 
     *
     * @param v value.
     */
    public static void setReconnectDelay(int v) {
        reconnectDelayInSeconds = v;
    }

    /**
     * Retrieves the reconnect delay in seconds. 
     *
     * @return int value 
     */
    public static int getReconnectDelay() {
        return reconnectDelayInSeconds;
    }

    /**
     * Sets the reconnect max retries. 
     *
     * @param v value.
     */
    public static void setReconnectMaxRetries(int v) {
        reconnectMaxRetries = v;
    }

    /**
     * Gets the reconnect max retries. 
     *
     * @return int value 
     */
    public static int getReconnectMaxRetries() {
        return reconnectMaxRetries;
    }

    /**
     * Sets reconnect enabled flag.
     *
     * @param v value.
     */
    public static void setReconnectEnabled(boolean v){
        reconnectEnabled = v;
    }

    /**
     * Gets reconnect enabled flag.
     *
     * @return boolean indicating whether reconnect is enabled or not.
     */
    public static boolean getReconnectEnabled() {
        return reconnectEnabled;
    }

}
