/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.system;

import java.util.Properties;
import java.util.logging.*;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorRuntime;

import com.sun.messaging.jms.management.server.DestinationType;
import com.sun.messaging.jms.management.server.MQObjectName;
/** 
 * Represents MQAdministrator of the default-jms-host of the 
 * target.
 *
 * @author Binod P.G
 */
public class MQAdministrator {

    static Logger logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    private static StringManager localStrings =
        StringManager.getManager( ConnectorRuntime.class);

    private String target = null;

    /**
     * Creates JMSAdmin object for the curremt Instance.
     */
    public MQAdministrator() {
    }

    /**
     * Creates JMSAdmin object from the name of the target passed in.
     *
     * @param target Name of the target. Eg: cluster1 or server1
     */
    public MQAdministrator(String target) 
                      throws ConnectorRuntimeException{
        this.target = target;
    }


    public void createPhysicalDestination(String destName,boolean isQueue )
                       throws ConnectorRuntimeException {

        MQJMXConnectorInfo mqInfo = null;
        try {
            if (this.target == null) {
                this.target = getClusterName();
            }

            mqInfo = MQJMXConnectorHelper.getMQJMXConnectorInfo(target) [0];
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName(
                 MQObjectName.DESTINATION_MANAGER_CONFIG_MBEAN_NAME);
            String [] signature = null;
            AttributeList destAttrs = null;
            Object [] params = null;
            String destType = DestinationType.TOPIC;

            destAttrs = new AttributeList();
            if (isQueue) {
                destAttrs.add(new Attribute(IASJmsUtil.getMaxActiveConsumersAttribute(),
                          new Long(IASJmsUtil.getDefaultMaxActiveConsumers())));
                destType = DestinationType.QUEUE;
            } 
            if (mqInfo.getBrokerType().equalsIgnoreCase(ActiveJmsResourceAdapter.LOCAL)) {
                destAttrs.add( new Attribute ("LocalDeliveryPreferred", 
                          new Boolean("true")));
            }
            if ((destAttrs == null) || (destAttrs.size() == 0)){
                signature = new String [] {
                     "java.lang.String",
                     "java.lang.String"};
                params = new Object [] {destType, destName};
            } else {
                signature = new String [] {
                     "java.lang.String",
                     "java.lang.String",
                     "javax.management.AttributeList"};
                params = new Object [] {destType, destName, destAttrs};
            }
            mbsc.invoke(on, "create", params, signature);
        } catch (Exception e) {
            handleException(e);
        } finally {
            try {
                if(mqInfo != null) {
                     mqInfo.closeMQMBeanServerConnection();
                }
            } catch (Exception e) {
                handleException(e);
            }
        }
    }

    private String getClusterName() throws ConfigException {
        return ClusterHelper.getClusterForInstance(
                        ApplicationServer.getServerContext().getConfigContext(),
                        ApplicationServer.getServerContext().getInstanceName()).getName();
    }


    private ConnectorRuntimeException handleException(Exception e) {
        logger.log(Level.WARNING,""+e.getMessage(), e);
        ConnectorRuntimeException cre = 
             new ConnectorRuntimeException(e.getMessage());
        cre.initCause(e);
        return cre;
    }

}
