
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.*;
import com.sun.enterprise.deployment.*;
import java.util.*;

/** Interface class of managed connection factory parser methods. 
 *  @author Srikanth P
 */


public interface MessageListenerConfigParser extends ConnectorConfigParser {


    /**
     *  Obtains the Message Listener types of a given rar.
     *  @param desc ConnectorDescriptor pertaining to rar.
     *  @return Array of MessageListener types as strings
     *  @throws ConnectorRuntimeException If rar is not exploded or 
     *                                    incorrect ra.xml 
     */

    public String[] getMessageListenerTypes(ConnectorDescriptor desc) 
                      throws ConnectorRuntimeException;

    /**
     *  Returns the ActivationSpecClass name for the given rar and message 
     *  listener type. 
     *  @param desc ConnectorDescriptor pertaining to rar.
     *  @param messageListenerType MessageListener type
     *  @throws ConnectorRuntimeException If rar is not exploded or
     *                                    incorrect ra.xml
     */

    public String getActivationSpecClass(ConnectorDescriptor desc,
          String messageListenerType) throws ConnectorRuntimeException;

    /** 
     * Returns the Properties object consisting of PropertyName as the key 
     * and the datatype as the value
     *  @param desc ConnectorDescriptor pertaining to rar.
     *  @param  messageListenerType message listener type.It is uniqie
     *          across all <messagelistener> sub-elements in <messageadapter>
     *          element in a given rar.
     *  @return properties object with the property names(key) and datatype
     *          of property(as value).
     *  @throws  ConnectorRuntimeException if either of the parameters are null.
     *           If corresponding rar is not deployed i.e moduleDir is invalid.
     *           If messagelistener type is not found in ra.xml
     */
  
    public Properties getJavaBeanReturnTypes(ConnectorDescriptor desc,
          String messageListenerType) throws ConnectorRuntimeException;
}
