/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.work.monitor;

import javax.resource.spi.work.WorkManager;

/**
 * An interface that adds SJSAS monitoring capabilities to the
 * work manager interface. All work manager implementations in
 * SJSAS would implement this interface if they are monitorable.
 * @author Sivakumar Thyagarajan
 */
public interface MonitorableWorkManager extends WorkManager {
    
    public boolean isMonitoringEnabled();
    
    //reset all counts when isEnabled = false;
    public void setMonitoringEnabled(boolean isEnabled);
    
    public long getCurrentActiveWorkCount();
    public long getMaxActiveWorkCount();
    public long getMinActiveWorkCount();
    

    public long getWaitQueueLength();
    public long getMaxWaitQueueLength();
    public long getMinWaitQueueLength();


    public long getSubmittedWorkCount();

    public long getRejectedWorkCount();

    public long getCompletedWorkCount();

    public long getMaxWorkRequestWaitTime();
    public long getMinWorkRequestWaitTime();
}