/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.util.Utility;
import com.sun.logging.*;

import java.io.*;
import java.util.logging.*;

/**
 * The class contains all the information relative to a particular deployment
 * Its lifetime isl imited to the actual deployment process.
 *
 * @author  Jerome Dochez
 * @version 
 */
public class DeploymentContext extends java.lang.Object {

    /**
     * the application descriptor we are deploying
     */
    private Application application;
    
    /**
     * Archive abstraction of the deployable application
     */
    private AbstractArchive archive=null;
    
    /**
     * Temporary directory used to generating the implementation classes
     */
    private File appTmpDir=null;
    

	static Logger _logger = LogDomains.getLogger(LogDomains.DPL_LOGGER);
    
    /** 
     * Creates new DeploymentContext 
     * 
     * @param application descriptor to be deployed
     */
    public DeploymentContext(AbstractArchive archive, Application application) {
        this.application = application;
        this.archive = archive;
    }

    /**
     * @return the Application object we are deploying
     */
    public Application getApplication() {
        return application;
    }
    
    /**
     * @return the archive abstraction used to represent the application
     * bunlde being deployed
     */
    public AbstractArchive getArchive() {
        return archive;
    }
    
    /**
     * @return the tmp output directory used to generate files that will be
     * added later to the cooked archive file
     */
    public File getOutputDirectory() {
        return new File(archive.getArchiveUri());
    }
    
    /**
     * @return the source directory where the content of this deployment has
     * been saved in 
     */ 
    public File getSourceDirectory() {
        return new File(archive.getArchiveUri());
    }    
    
    /**
     * @return the class loader that should be used for loading classes during
     * deployment
     */
    public ClassLoader getClassLoader() {
        return application.getClassLoader();
    }
       
    /**
     * delete all content of a given directory
     */
    public static void deleteDirectory(File dir) {
	File[] files = dir.listFiles();
	if (files != null) {
	    for(int i=0; i < files.length; ++i) {
		File child = files[i];
		if(child.isDirectory()) {
		    deleteDirectory(child);
		} 
		child.delete();
	    }
	}
	dir.delete();
    }
    
}
