/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EnterpriseInfo.java
 *
 * Created on November 15, 2001, 9:17 PM
 */

package com.sun.enterprise.deployment.backend;

import java.io.*;
import java.util.*;
import com.sun.enterprise.util.io.FileUtils;

/**
 *
 * @author  bnevins
 * @version 
 */

abstract public class DeployableObjectInfo {

	protected DeployableObjectInfo(File rootPath, String name) 
	{
		this(rootPath, name, null);
	}

	///////////////////////////////////////////////////////////////////////////

	protected DeployableObjectInfo(File rootPath, String name, File archive) 
	{
		this.rootPath	= rootPath;
		this.name		= name;
		this.archive	= archive;
	}

	///////////////////////////////////////////////////////////////////////////

	/** Prepares a human-readable dump of all the information
	 * contained by this Object.  Recursively calls toString()
	 * on contained objects.
	 * @return Returns a String
	 */	
	public String toString()
	{
		StringBuffer sb = new StringBuffer("*********** Archive Info Dump ***********\n");
		
		sb.append("Root Path:        " + getRootPath() + '\n');
		sb.append("Name:             " + getName() + '\n');
		
		if(archive != null)
			sb.append("Original Archive: " + getArchive() + '\n');
		
		return sb.toString();
	}

	///////////////////////////////////////////////////////////////////////////

	/** Returns the official name (ID) of the object
	 * @return The String ID of this object
	 */	
	public String getName()
	{
		return name;
	}


	///////////////////////////////////////////////////////////////////////////

	/** Returns the top-level directory that this object resides in
	 * @return A File object pointing at the top-level directory containing this object
	 */	
	public File getRootPath()
	{
		return rootPath;
	}

	///////////////////////////////////////////////////////////////////////////

	File getArchive()
	{
		return archive;
	}

	///////////////////////////////////////////////////////////////////////////

	private File				rootPath;
	private String				name;
	private File				archive		= null;
}
