/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentEventManager.java
 *
 * Created on April 8, 2003.
 */

package com.sun.enterprise.deployment.backend;

import java.util.Iterator;
import java.util.Vector;

/**
 * The <code>DeploymentEventManager</code> delivers a <code>DeploymentEvent</code> 
 * event to each <code>DeploymentEventListener</code> that registered itself 
 * with this <code>DeploymentEventManager</code>.
 *
 * @author Marina Vatkina
 */
public class DeploymentEventManager
{
    /** Event listeners */
    private static Vector listeners = new Vector();

    /** Adds this DeploymentEventListener to the list of listeners.
     * @param listener to be added.
     */
    public static void addListener(DeploymentEventListener listener) {
        listeners.add(listener);
    }

    /** Removes this DeploymentEventListener from the list of listeners.
     * @param listener to be removed.
     */
    public static void removeListener(DeploymentEventListener listener) {
        listeners.remove(listener);
    }

    /** Notifies all known DeploymentEventListener listeners about the event.
     * @param event the DeploymentEvent to send to all listeners.
     */
    public static void notifyDeploymentEvent(DeploymentEvent event) {
        for (Iterator it = ((Vector)listeners.clone()).iterator(); it.hasNext();) {
            ((DeploymentEventListener)it.next()).notifyDeploymentEvent(event);
        }
    
    }
}
