/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;

/**
 * This tag class is used to indentify an object holding 
 * information to rollback an already successfully executed
 * phase. Each phase should implement and return an instance
 * of this interface to be passed to the rollback method for
 * information on what needs to be rollbacked.
 * 
 * @author Jerome Dochez
 */
 
public interface DeploymentPhaseContext {
    
    /**
     * @return the deployment request for this phase
     */
    public DeploymentRequest getDeploymentRequest();
    
    /**
     * @return the deployment status for this phase
     */
    public DeploymentStatus getDeploymentStatus();
    
    /**
     * Set the deployment status for this phase
     */
    public void setDeploymentStatus(DeploymentStatus status);    
    
    /**
     * Set the deployment request for this phase
     */
    public void setDeploymentRequest(DeploymentRequest req);
}
