/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.enterprise.diagnostics.util.UniqueNameGenerator;

/**
 * Generates a zip file containing diagnostic data
 * @author Manisha Umbarje
 */
public class Archiver {
   
    
    private static Logger logger = 
            LogDomains.getLogger(LogDomains.ADMIN_LOGGER);
    /** Creates a new instance of Archiver */
    public Archiver() {
    }
    
    /**
     * generates zip file containing diagnostic report
     * @param file  name of archived file
     * @param target target at which report generation is invoked
     * @throws com.sun.enterprise.diagnostics.DiagnosticException 
     * @return zip file containing diagnostic report.
     */
    public java.util.jar.JarFile archive(ReportTarget target, String file)
            throws DiagnosticException {
        try {
            if (file == null) {
                // Generate uniqu name
                file = File.separator + target.getDefaultReportDir() + 
                        File.separator + 
                        UniqueNameGenerator.getName(target.getName());              
            }
            String dirTobeArchived = target.getArchiveDir();
            
            // Generate the jar file
            FileUtils.jarDirectory(new File(file),dirTobeArchived);
            
            //Delete report folder
            FileUtils.deleteFile(dirTobeArchived);

            return new java.util.jar.JarFile(file);
            
        } catch (IOException ioe) {
            throw new DiagnosticException(ioe.getMessage());
        }
    }
}
