/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;


/**
 * Combined representation of diagnostic-service config elements in domain.xml
 * and command line options provided by the user at the time of report
 * generation. 
 * @author Manisha Umbarje
 */
public class ReportConfig {

    //CLI options
    private CLIOptions options;
    
    //Represents the target for which report is being generated
    private ReportTarget target;    
    
    private ExecutionContext context;
    
    // Configurtion of diagnostic-service element
    private List<ServiceConfig> configurations ;
    
    /**
     * Creates new instance of ReportConfig object
     */
    public ReportConfig(CLIOptions cliOptions, ReportTarget target, 
            ExecutionContext context) throws DiagnosticException {
        options = cliOptions;
        this.target = target;
        this.context = context;
        initialize();
    }
    
    /**
     * Add diagnostic service configuration corresponding to a instance
     * @param config diagnostic service config element from domain.xml
     */
    public void addInstanceSpecificConfig(ServiceConfig config) {
        if(config != null) {
            configurations.add(config);
        }
    }
    
    public void addInstanceConfigs(List<ServiceConfig> configs) {
        if(configs != null) {
            Iterator<ServiceConfig> iterator = configs.iterator();
            while(iterator.hasNext()) {
                addInstanceSpecificConfig(iterator.next());
            }
        }
    }

    public ServiceConfig getInstanceConfigByName(String name){
        ServiceConfig instanceConfig = null;
        for(ServiceConfig config : configurations){
            if(config.getInstanceName().equalsIgnoreCase(name)){
                instanceConfig = config;
                break;
            }
        }
        return instanceConfig;
    }
    
    /**
     * returns ReportTarget
     * @return target
     */
    public ReportTarget getTarget() {
        return target;
    }
    
    /**
     * @return CLIOptons
     */
    public CLIOptions getCLIOptions() {
        return options;
    }
    
    /**
     * Returns Execution context
     */
    public ExecutionContext getExecutionContext() {
        return context;
    }
    /**
     * In PE, only one configuration is returned. 
     * In SE/EE the report generation may be invoked for multiple instances
     * @return list of configurations
     */
    public Iterator<ServiceConfig> getInstanceConfigurations() {
         return configurations.iterator();
    }
 
    public String toString() {
        return options.toString() + target.toString() +  
                context.toString() +  configurations;
    }
    private void initialize() {
        configurations = new ArrayList();
    }
}
