/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import java.util.List;
import java.util.zip.ZipFile;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.report.html.HTMLReportWriter;

/**
 * Collects data, generates HTML report and archives it if mode is local
 * @author mu125243
 */
public class ReportGenerator {

    protected ReportConfig config;
    protected Collector harvester;
    protected HTMLReportWriter reportWriter;

    /** Creates a new instance of ReportGenerator */
    public ReportGenerator(ReportConfig config, Collector harvester, 
            HTMLReportWriter reportWriter) {
        this.config = config;
        this.harvester = harvester;
        this.reportWriter = reportWriter;
    }
    
    /** Captures data, writes HTML report and archives it in local mode
     * @return Data object
     */
    public java.util.zip.ZipFile generate() 
    throws DiagnosticException {
        Data data = collectData();
        writeReportSummary(data);
        return archive(config.getTarget(), config.getCLIOptions().getReportFile());
    }
    
    private Data collectData() throws DiagnosticException {
        if(harvester != null) {
            ((com.sun.enterprise.diagnostics.collect.Harvester)harvester).initialize();
            return harvester.capture();
        }
        throw new DiagnosticException("Harvester null");
    }
    
    protected void writeReportSummary(Data data) 
    throws DiagnosticException {
        if(reportWriter != null) 
            reportWriter.writeReportSummary(data);
        else
            throw new DiagnosticException("HTML Report writer == null");
    }
    
    protected ZipFile archive(ReportTarget target, String archiveName)
    throws DiagnosticException {
        return new Archiver().archive(config.getTarget(), archiveName);
    }
 }
