/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import java.util.List;
import java.io.File;
/**
 *
 * @author mu125243
 */
public class ReportTarget {
    protected String targetDir;
    protected String targetName;
    protected String repositoryName;
    protected String repositoryDir;
    protected TargetType type;
    protected List<String> instances;
    private boolean local ;
    private static Logger logger = 
    LogDomains.getLogger(LogDomains.ADMIN_LOGGER);
    
    /** Creates a new instance of ReportServiceConfig */
    public ReportTarget(String repositoryDir, String repositoryName, String targetName, 
            TargetType type, List<String> instances, boolean local) {
        this.repositoryDir = repositoryDir;
        this.repositoryName = repositoryName;
        this.targetDir = repositoryDir + File.separator + repositoryName;
        this.targetName = targetName;
        this.type = type;
        this.instances = instances;
        this.local = local;
      
    }
    /**
     * Retrieves the type of this target
     * @return target type
     */
    public TargetType getType() {
        return type;
    }
    
    /**
     * Returns target name
     * @return target name
     */
    public String getName() {
        return targetName;
    }
    
      
    /**
     * @return  name of the central/cache repository
     */
    public String getRepositoryDir() {
          return repositoryDir;
    }
    
    public String getTargetDir() {
        return targetDir;
    }

    public String getRepositoryName() {
        return repositoryName;
    }
    /**
     * @return name of the temp folder in which data is collected before 
     * compressing it
     */
    public String getIntermediateReportDir() {
        return  getArchiveDir() + File.separator + targetName; 
    }

    public String getArchiveDir(){
        return repositoryDir + File.separator +
                repositoryName + Defaults.TEMP_REPORT_FOLDER;
    }

    /**
     * @return default directory in which diagnostic report is stored
     */
    public String getDefaultReportDir() {
        return targetDir + Defaults.REPORT_FOLDER;
    }   
    
    public List<String> getInstances() {
        return instances;
    }
    public String toString() {
        return getName() +"," + getType() + "," + getRepositoryDir() + "," +
                getIntermediateReportDir() + "," + getDefaultReportDir() + 
                "," + getInstances();
    }
}
