/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

/**
 * Encapsulate a single HTML document.  This holds a single HTML
 * element with head and body elements, and allows specifying the
 * document type.
 */
public interface Document extends HTMLComponent {

    /**
     * Get the body element of this HTML document.
     * @return	The body element.
     */
    public Element getBody();
    
    /**
     * Get the head element of this HTML document.
     * @return	The head element.
     */
    public Element getHead();
    
    /**
     * Replace the content of this document with the specified
     * head and body.
     * 
     * If the head element does not have the name HEAD, or the body
     * element does not have the name BODY, then an additional, new
     * element is created with the appropriate name, and the input
     * element is added to this element.
     * @param head A new head element.
     * @param body A new body element.
     * @return	This document.
     */
    public void set(Element head, Element body);
    
    /**
     * Get the current doctype string.
     * @return	The current doctype string.
     * @see #setDoctype(String)
     */
    public String getDoctype();
    
    /**
     * Explicitly set the doctype of this document.  Right now the
     * raw doctype string is given.  It will be converted into a line
     * of the form:<br/>
     * <code>&lt;!DOCTYPE html PUBLIC "<em>raw</em>"&gt;</code>
     * <p>
     * This is not very flexible; perhaps this should be re-visited in
     * the future.
     * @param raw	The raw doctype string.
     * @return	This document.
     */
    public void setDoctype(String raw);
}
