/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

import java.util.List;

/**
 * A single element in an HTML document.  Elements may contain
 * other elements and text, in a strict order.  They may also
 * have attributes assigned to them.
 */
public interface Element extends Container {

    /**
     * Add a element to  this element.  
     * @param name The name of the new element.
     */
    public Element addElement(String name);
    
    /**
     * Add a attribute to this element.  
     * @param id The name of the attribute.
     * @param value The value of the attribute.
     */
    public Attribute addAttribute(String id, String value);
    
    /**
     * Factory method to create a new comment and add it to this
     * element.  The content of the comment is escaped as appropriate.
     * @param content	The content of this comment.
     * @return	The new comment.
     * @see Text
     */
    public Text addComment(String content);
    
    /**
     * Factory method to create a new text instance and add it to this
     * element.  The content of the text is escaped as appropriate.
     * @param text	The text to add.
     * @return	The new text instance.
     */
    public Text addText(String text);
    
    /**
     * Get all child elements of this element.
     * @return	The list of child elements.
     */
    public List<Element> getElements();
    
    /**
     * Get all child elements of this element which have the specified
     * name.
     * @param name	The element name.
     * @return	The list of child elements.
     */
    public List<Element> getElements(String name);
    
    /**
     * Get all comments in this element.
     * @return	The list of all comments.
     */
    public List<Text> getComments();
    
    /**
     * Get all text contained in this element.
     * @return	The list of text nodes contained in this element.
     */
    public List<Text> getTexts();
    
    /**
     * Get all attributes of this element.
     * @return	The list of all attributes.
     */
    public List<Attribute> getAttributes();
    
    /**
     * Get all attributes of this element whose name matches the given
     * name.
     * @param name	The attribute name.
     * @return	The list of all matching attributes.
     */
    public List<Attribute> getAttributes(String name);
    
    /**
     * Get the name of this element.
     * @return	The name of this element.
     */
    public String getName();
    
    /**
     * Set the name of this element.  The previous name is discarded.
     * Note that element names are not case-sensitive; on output they
     * are all converted to upper-case.
     * @param name The new name of this element.
     */
    public void setName(String name);
}
