/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop;

import org.omg.PortableInterceptor.ClientRequestInfo;

import com.sun.enterprise.*;
import com.sun.corba.ee.spi.legacy.interceptor.RequestInfoExt;
import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import java.util.logging.*;
import com.sun.logging.*;

public class ClientConnectionInterceptor extends org.omg.CORBA.LocalObject
    implements org.omg.PortableInterceptor.ClientRequestInterceptor,
        Comparable
{
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.CORBA_LOGGER);
        }
    public String name;
    public int order;

    /**
     * Create the interceptor.
     * @param the name of the interceptor.
     * @param the order in which the interceptor should be invoked.
     */
    public ClientConnectionInterceptor(String name, int order)
    {
	this.name = name;
	this.order = order;
    }

    public int compareTo(Object o)
    {
	int otherOrder = -1;
	if(o instanceof ClientConnectionInterceptor) {
	    otherOrder = ((ClientConnectionInterceptor)o).order;
	}
	if (order < otherOrder) {
	    return -1;
	} else if (order == otherOrder) {
	    return 0;
	}
	return 1;
    }

    /**
     * Return the name of the interceptor.
     * @return the name of the interceptor.
     */
    public String name() { 
	return name; 
    }


    public void send_request(ClientRequestInfo cri)
    {
	// Check if there is an exportable transaction on current thread
	Object target = cri.effective_target();
	J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
	if ( tm != null )
	    tm.checkTransactionExport(StubAdapter.isLocal(target));

	// Get connection information and store it in ConnectionContext
	Connection c = ((RequestInfoExt)cri).connection();
	if(c != null) {
	    SecurityMechanismSelector sms = new SecurityMechanismSelector();
	    ConnectionContext cc = sms.getClientConnectionContext();
	    if(_logger.isLoggable(Level.FINE)){
		 _logger.log(Level.FINE,"SENDING request on connection: " + c);
	    }
	    if(cc != null) {
	        cc.setSocket(c.getSocket());
	    }
	}
    }

    public void destroy() {
    }

    public void send_poll(ClientRequestInfo cri) {
    }

    public void receive_reply(ClientRequestInfo cri) {
    }

    public void receive_exception(ClientRequestInfo cri) {
    }

    public void receive_other(ClientRequestInfo cri) {
    }
}

