/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.Set;

/**
 * Interface representing J2EE Resource info.
 *
 * @author Kenneth Saks
 */
public interface J2EEResource {

    /**
     * Resource Types
     */
    int JMS_DESTINATION    = 1;
    int JMS_CNX_FACTORY    = 2;
    int JDBC_RESOURCE      = 3;
    int JDBC_XA_RESOURCE   = 4;
    int JDBC_DRIVER        = 5;
    int CONNECTOR_RESOURCE = 6;
    int RESOURCE_ADAPTER   = 7;

    // START OF IASRI #4626188
    int JDBC_CONNECTION_POOL   = 8;
    int PMF_RESOURCE           = 9;
    int EXTERNAL_JNDI_RESOURCE = 10;
    int CUSTOM_RESOURCE        = 11;
    // START OF IASRI #4650786
    int MAIL_RESOURCE          = 12;
    // END OF IASRI #4650786
    // END OF IASRI #4626188
    
    /**
     * Resource name. Immutable.
     */
    String getName();

    /**
     * Resource type.  Defined above. Immutable.
     */
    int getType();

    /**
     * Set containing elements of type ResourceProperty.
     * Actual property names are resource type specific.
     * @return Shallow copy of resource property set. If
     *         resource has 0 properties, empty set is
     *         returned.
     */
    Set getProperties();

    /**
     * Add a property. Underlying set is keyed by
     * property name.  The new property overrides any
     * existing property with same name.
     */
    void addProperty(ResourceProperty property);

    /**
     * Remove a property. Underlying set is keyed by
     * property name.  
     * @return true if property was removed, false if
     *         property was not found
     */
    boolean removeProperty(ResourceProperty property);

     /**
     * Get a property with the given name.
     * @return ResourceProperty or null if not found.
     */
    ResourceProperty getProperty(String propertyName);
    
    /**
     * Create a new resource with the given name
     * that has the same attribute and property
     * settings as the invoked object.
     */
    J2EEResource makeClone(String name);
    
    // START OF IASRI #4626188
    void setEnabled(boolean value);
    boolean isEnabled();
    void setDescription(String value);
    String getDescription();
    // END OF IASRI #4626188
}
