/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

/**
 * Exception thrown for J2EEResource errors.
 *
 * @author Kenneth Saks
 */ 
public class J2EEResourceException extends Exception {

    private Exception exception_;
    private String errorMsg_;

    public J2EEResourceException(String errorMsg) {
        errorMsg_ = errorMsg;
    }

    public J2EEResourceException(Exception exception) {
        exception_ = exception;
    }

    public Exception getNestedException() {
        return exception_;
    }

     public String toString() {
        if (exception_ == null) {
            return errorMsg_ + " : " + super.toString();
        } else {
            return super.toString() + "\n" + exception_.toString();
        }
    }
}
