/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;
import java.util.Set;
import java.util.Iterator;
import com.sun.enterprise.util.LocalStringManagerImpl;

/**
 * Resource info for Jms Connection Factory info,
 * both topic and queue.
 *
 * @author Kenneth Saks
 */
public class JmsCnxFactoryResource extends J2EEResourceBase 
    implements Serializable {

    private static LocalStringManagerImpl localStrings =
        new LocalStringManagerImpl(JmsCnxFactoryResource.class);

    private boolean isQueue_;

    public JmsCnxFactoryResource(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        JmsCnxFactoryResource clone = new JmsCnxFactoryResource(name);
        clone.setIsQueue(getIsQueue());
        return clone;
    }

    public int getType() {
        return J2EEResource.JMS_CNX_FACTORY;
    }

    //START IASRI 4675235
    public String getTypeString() {
        if (getIsQueue()) return IASJ2EEResourceFactoryImpl.JMS_QUEUE_CONNECTION_FACTORY;
        return IASJ2EEResourceFactoryImpl.JMS_TOPIC_CONNECTION_FACTORY;
    }
    //END IASRI 4675235

    public boolean getIsQueue() {
        return isQueue_;
    }
    
    public void setIsQueue(boolean isQueue) {
        isQueue_ = isQueue;
    }

    public String toString() {
        String propsString = getPropsString();
        
        //START IASRI 4675235
        String npMsg = localStrings.getLocalString("enterprise.repository.resource_noproperties", "No Properties");

        return "< JMS Connection Factory: " + getName() + ", " +
                  getTypeString()+ ", " +
                  ((propsString.length() > 0) ?
                  propsString : npMsg) + " >";
        //END IASRI 4675235

    }
}
