/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;

/**
 * Resource info for Persistence Manager Factory
 * IASRI #4626188
 * @author Sridatta Viswanath
 */
public class PMFResource extends J2EEResourceBase implements Serializable {

    private String factoryClass_;
    private String jdbcResourceJndiName_;
    
    public PMFResource(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        PMFResource clone = new PMFResource(name);
        clone.setFactoryClass(getFactoryClass());
        clone.setJdbcResourceJndiName(getJdbcResourceJndiName());
        return clone;
    }

    public int getType() {
        return J2EEResource.PMF_RESOURCE;
    }

    public String getFactoryClass() {
        return factoryClass_;
    }
    
    public void setFactoryClass(String factoryClass) {
        factoryClass_ = factoryClass;
    }
    
    public String getJdbcResourceJndiName() {
        return jdbcResourceJndiName_;
    }
    
    public void setJdbcResourceJndiName(String jdbcResourceJndiName) {
        jdbcResourceJndiName_ = jdbcResourceJndiName;
    }
    
    public String toString() {
        return "< PMF Resource : " + getName() + "... >";
    }
}
