/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.resource;

/**
 * An interface that adds 8.1 monitoring capabilities to the ResourcePool
 * interface 
 * @author Sivakumar Thyagarajan
 * @since 8.1
 */
public interface MonitorableResourcePool extends ResourcePool {
    
    /**
     * Return the number of threads that are waiting
     * to obtain a connection from the pool
     */
    public int getNumThreadWaiting();
    
    /**
     * Return the number of connections that have failed validation
     */
    public long getNumConnFailedValidation();
    
    /**
     * Return the number of threads that have time out after
     * waiting to obtain a connection from the pool.
     */
    public long getNumConnTimedOut();
    
    /**
     * Return the number of free connections in the pool
     */
    public long getNumConnFree();
    public long getMaxNumConnFree();
    public long getMinNumConnFree();
    
    /**
     * Return the number of connections in use 
     */
    public long getNumConnInUse();
    public long getMinNumConnUsed();
    
    /**
     * Return the maximum number of connections ever used in
     * this pool
     */
    public long getMaxNumConnUsed();
    
    //8.1 pool monitoring statistics
    public long getCurrentConnRequestWaitTime();
    public long getMaxConnRequestWaitTime();
    public long getMinConnRequestWaitTime();
    public long getTotalConnectionRequestWaitTime();
    
    
    public long getNumConnCreated();
    public long getNumConnDestroyed();
    
    public long getNumConnAcquired();
    public long getNumConnReleased();
    
    public long getNumConnSuccessfullyMatched();
    public long getNumConnNotSuccessfullyMatched();
}
