/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.util.LocalStringManagerImpl;
/**
 * LoginException is thrown by the LoginContext class whenever
 * the following happens: <UL>
 * <LI> If the client is unable to authenticate successfully with the 
 * </UL>
 * @see com.sun.enterprise.security.auth.AuthenticationStatus
 * @author Harish Prabandham
 * @author Harpreet Singh
 */

public class LoginException extends SecurityException {

    private static LocalStringManagerImpl localStrings = 
        new LocalStringManagerImpl(LoginException.class);

    private boolean status = false;


    /**
     * Create a new LoginException object with the given message
     * @param The message indicating why authentication failed.
     */
    public LoginException(String message) {
	super(message);
    }

    
    /**
     * Create a new LoginException object with the given authentication
     * value.
     * @param The AuthenticationStatus object
     */
    public LoginException(boolean as){
	super(localStrings.getLocalString("enterprise.security.login_failed", 
					   "Login Failed."));
	status = as;
    }

    
    /**
     * Returns the status of the Authentication.
     */
    public boolean getStatus(){
	return status;
    }
    
}




