/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.RealmConfig;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.logging.LogDomains;

/**
 * This class extends default implementation of ServerLifecycle interface.
 * It provides security initialization and setup for the server.
 * @author  Shing Wai Chan
 */
public class SecurityLifecycle extends ServerLifecycleImpl {
    private static final Logger _logger = LogDomains.getLogger(LogDomains.SECURITY_LOGGER);

    public SecurityLifecycle() {
	try {
            // security manager is set here so that it can be accessed from
            // other lifecycles, like PEWebContainer
            String serverPolicyFile = System.getProperty("java.security.policy");

            SecurityManager secMgr = System.getSecurityManager();
            if (secMgr != null &&
                    !(J2EESecurityManager.class.equals(secMgr.getClass()))) {
                J2EESecurityManager mgr = new J2EESecurityManager();
                System.setSecurityManager(mgr);
            }
            
            if (_logger.isLoggable(Level.INFO)) {
                if (secMgr != null) {
                    _logger.info("security.secmgron");
                } else {
                    _logger.info("security.secmgroff");
                }
            }
	} catch(Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
	}
    }   

    // override default
    public void onInitialization(ServerContext sc)
            throws ServerLifecycleException {

        try {
            // init SSL store
            // need this for jaxr https for PE
            // need this for webcore, etc for SE
            SSLUtils.initStoresAtStartup();

            // jacc
            registerPolicyHandlers();
            PolicyLoader policyLoader = PolicyLoader.getInstance();
            policyLoader.loadPolicy();

            // create realms rather than creating RemoteObject RealmManager
            // which will init ORB prematurely
            RealmConfig.createRealms();

            // start the audit mechanism
            AuditManagerFactory amf = AuditManagerFactory.getInstance();
            amf.getAuditManagerInstance().loadAuditModules();

            // initRoleMapperFactory is in J2EEServer.java and not moved to here
            // this is because a DummyRoleMapperFactory is register due
            // to invocation of ConnectorRuntime.createActiveResourceAdapter
            // initRoleMapperFactory is called after it
        } catch(Exception ex) {
            throw new ServerLifecycleException(ex);
        }
    }

    private void registerPolicyHandlers()
            throws javax.security.jacc.PolicyContextException {
        PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
        PolicyContext.registerHandler(PolicyContextHandlerImpl.ENTERPRISE_BEAN,
            pch, true);
        PolicyContext.registerHandler(PolicyContextHandlerImpl.SUBJECT, pch, true);
        PolicyContext.registerHandler(PolicyContextHandlerImpl.EJB_ARGUMENTS,
            pch, true);
        PolicyContext.registerHandler(PolicyContextHandlerImpl.SOAP_MESSAGE,
            pch, true);
        PolicyContext.registerHandler(PolicyContextHandlerImpl.HTTP_SERVLET_REQUEST,
            pch, true);
        PolicyContext.registerHandler(PolicyContextHandlerImpl.REUSE, pch, true);
    }
}
